/*
| -----------------------------------------------------------------------------
| Filename: main.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|
| Description: 
| This is a RoBiOS demo user program
| It`s a very simple example.
| -----------------------------------------------------------------------------
*/

#include "eyebot.h"

MotorHandle     leftmotor;
MotorHandle     rightmotor;

char    z;

int main ()
{
	LCDMode(SCROLLING|NOCURSOR);
	LCDMenu("","","","END");

	LCDPutString("Roll on ...\n");

	leftmotor = MOTORInit(LEFTMOTOR);
	rightmotor = MOTORInit(RIGHTMOTOR);

	if(!leftmotor||!rightmotor) 
		{
			LCDPutString("Init Error!\n");
			KEYWait(ANYKEY);
			return(-1);
		}

	MOTORDrive (rightmotor,50);
	MOTORDrive (leftmotor,-50);

	while (z!=KEY4)
	{
	    z = KEYRead();
	}

	MOTORRelease (rightmotor|leftmotor);

	return(0);
}

