/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * and Mari Wang <mariw@tartarus.uwa.edu.au>
 * Date: 1999-11-27
 *
 * Test speed of RoBIOS functions.
 */

#include <eyebot.h>
#include <stdio.h>
#include "../timerheader.h"

#include <math.h>

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define POW(a) ((a)*(a))

typedef BYTE hsiimage[3][imagerows][imagecolumns];

int
IPGreyAverage(colimage *img)
{
  int sum = 0, count = 0;
  int row, column;
  for (row = 1; row < imagerows-1; row++)
    for (column = 1; column < imagecolumns-1; column++)
      {
        sum += (*img)[row][column][0]; /* red */
        sum += (*img)[row][column][1]; /* green */
        sum += (*img)[row][column][2]; /* blue */
        count++;
      }
  return sum / count;
}

int
IP_Color2GreyE(colimage *src, image *dest)
{
  register int row;
  register int column;
  for (row = 1; row < imagerows-1; row++)
    for (column = 1; column < imagecolumns-1; column++)
      {
        register int val;
        val  = (*src)[row][column][0];
        val += (*src)[row][column][1];
        val += (*src)[row][column][1];
        val += (*src)[row][column][2];
        val >>= 6;
        (*dest)[row][column] = val;
      }
  
  return 0;
}

int                  
IP_Color2Grey(colimage *src, image *dest)
{
  int row, column;
  for (row = 1; row < imagerows-1; row++)
    for (column = 1; column < imagecolumns-1; column++)
      {
        int val;
        val  = ((*src)[row][column][0]
		+ (*src)[row][column][1]
		+ (*src)[row][column][2])/3;
        (*dest)[row][column] = val >> 4;
      }

  return 0;
}

int
IP_ImageRGB2HSI(colimage *src, hsiimage *dst)
{
  int row, column;
  for (row = 1; row < imagerows-1; row++)
    for (column = 1; column < imagecolumns-1; column++)
      {
        double r,g,b, h,s,i, minrgb;
#define MAXBYTE 255
        r = (*src)[row][column][0] / MAXBYTE;
        g = (*src)[row][column][1] / MAXBYTE;
        b = (*src)[row][column][2] / MAXBYTE;

        i = (r+g+b)/3;
        if (0 == i) /* 0 intensity, h and s are undefined */
          {
            h = s = 0;
          }
        else
          {
            minrgb = MIN(r,MIN(g,b));
            s = 1 - (3*minrgb / (r+g+b));
            if (0 == s)
              { /* 0 saturation, h is undefined */
                h = 0;
              }
            else
              {
                h = acos( (r-g)+(r-b)
                          / 2 * sqrt( POW(r-g) + (r-b)*(g-b)) );
                if ( (b/i) > (g/i) )
                  h = 2*M_PI - h;
                h = h / (2*M_PI);
              }
          }

        (*dst)[0][row][column] = h * MAXBYTE;
        (*dst)[1][row][column] = s * MAXBYTE;
        (*dst)[2][row][column] = i * MAXBYTE;

      }
  return 0;
}

int
main(int argc, char *argv[])
{
  char *function_type = "Image Processing Functions"; /* Fill in
                                             * adequate name of
                                             * functions currently
                                             * being tested */

  /* File specific variables (those needed for testing */
  colimage cimg1;
  hsiimage himg1;
  image img1, img2, img3;

  index += init_test(function_type);

  /* Functions to be tested go here.
   * Semantics: do_test(function_name, parameters);
   */

  /* functions currently in RoBIOS */
  do_test(IPLaplace,(himg1[2], &img2));
  do_test(IPSobel,(&img1, &img2));
  do_test(IPDither,(&img1, &img2));
  do_test(IPDiffer,(&img1, &img2, &img3));
  do_test(IP_Color2Grey,(&cimg1, &img2));

  /* functions specified in this file */
  do_test(IPGreyAverage,(&cimg1));
  do_test(IPColor2Grey,(&cimg1, &img2));
  do_test(IP_Color2GreyE,(&cimg1, &img2));
  do_test(IP_ImageRGB2HSI,(&cimg1, &himg1));

  end_test();

  return 0;
}
