/** @author Peter Vanopulos
    @date 29/11/99
    @filename wall.c
    @memo
	The purpose of this file is to make the robot drive along a wall.
  Instead of sensing the wall is now very close and abruptly turning\
  the objective is to turn the robot smothly.
*/

#include "eyebot.h"

#define v_lin 7.0
#define t_lin 0.3
#define v_rot 10.0
#define t_rot 0.1   
#define PI 3.141516
#define front_distance 500
#define limit 10		

/* function prototypes */

/* global variables */
MotorHandle     leftmotor, leftmotor;
PSDHandle       psd_front, psd_left, psd_right;
VWHandle        vw;

int old_left, old_right, old_front;
int new_left, new_right, new_front;
int wall_distance;


void main ()
{ /* clear display and write message */
  LCDMode(SCROLLING|NOCURSOR);
  LCDMenu("","","","END");

  LCDPutString("Roll on ...\n");
  vw=VWInit(VW_DRIVE,1); /* parameter for scale i.e. 100Hz*/			
  VWStartControl(vw, v_lin, t_lin , v_rot, t_rot);

  /* initialise the PSD's */
  psd_front = PSDInit(PSD_FRONT);
  psd_left = PSDInit(PSD_LEFT);
  psd_right = PSDInit(PSD_RIGHT);
  PSDStart(psd_front, TRUE);
  PSDStart(psd_left,TRUE);
  PSDStart(psd_right,TRUE);
  OSWait(10);

                
  /* intialise the old values */
  old_left = PSDGet(psd_left);
  old_right = PSDGet(psd_right);
  old_front = PSDGet(psd_front);

  wall_distance = old_left;
  LCDPrintf("Dist: %d\n", wall_distance);
  do{
    old_left = PSDGet(psd_front);
    wall_distance = old_left;
    LCDPrintf("Dist: %d\n", wall_distance);
  }while( wall_distance > front_distance);

  while(KEYRead() != KEY4)    /* loop until the end button is hit */
  { new_left = PSDGet(psd_left);
    new_right = PSDGet(psd_right);
    new_front = PSDGet(psd_front);

    if(new_front > wall_distance)
    {

      if( abs(new_left-wall_distance) < limit )
        VWDriveStraight(vw,0.01,0.2); 
      else
      {	/* follow the left wall */
        if(new_left > old_left)
        {        /* turn left */
          LCDPrintf("%d: move in\n", new_left);
	  VWDriveCurve(vw,0.15,PI/17,0.4);
	}
	else if(new_left < old_left)
        {	/* turn right */	
	  LCDPrintf("%d: move out\n", new_left);
          VWDriveCurve(vw,0.15,-PI/17,0.4);
	}
        LCDPrintf("Dist: %d\n", wall_distance);
      }
    }

    /* otherwise we need to make a turn */
    else 
    {	/* turn the corner right */
      LCDPutString("Turning Right\n");
      VWDriveCurve(vw,0.2,-PI/2,0.2);
      VWDriveWait(vw);
    }  

    /* update the PSD sensors */
    old_left = new_left;
    old_right = new_right;
    old_front = new_front;

    OSWait(10); /* wait for 10/100 s. -- do not new calc. pos. if not moved */
    }/* end while loop */
    
    LCDPutString("END Button pressed\n");
    VWRelease(vw);
    PSDRelease();
}

