/* OMNI Remote                      */
/* Drives Omni robot with           */
/* wireless infrared remote         */
/* -------------------------------- */
/* Martin Wicke,           UWA 2000 */
/* adapted: Thomas Braunl, UWA 2000 */

#define STD_V 		1.0
#define STD_W			(M_PI/3)
#define DEG2RAD		(M_PI/180)

#include "eyebot.h"
#include "libomni/omni.h"
#include "irtv.h"
#include "IRnokia_vcn620.h"
#include <math.h>
#include <stdio.h>

void main(void)
{
	int terminated = 0;
	int code = 0;
	meterPerSec v = 0;
	radians d = 0;
	radPerSec w = 0;

	VWHandle vw = OMNI_Init(VW_DRIVE, 1);

	LCDPrintf("OMNI_Init: %d\n", vw);
  /* LCDPrintf("OMNI_S.C.: %d\n", OMNI_StartControl(vw,0.09 ,0.3,1.0,0.1));*/
	LCDPrintf("IRTVInit: %d\n", IRTVInit(SPACE_CODE,15,0,0x03ff,SLOPPY_MODE,1,10));

	while (!terminated)
	{ switch (code = IRTVRead())
		{ case 0: break;
		  case RC_0:
		  	LCDPrintf("0\n");
		  	break;
		  case RC_1: 
		  	LCDPrintf("1\n");
		  	v = STD_V;
		  	d = DEG2RAD * 45;
		  	break;
		  case RC_2:
		  	LCDPrintf("2\n");
		  	v = STD_V;
		  	d = 0;
		  	break;
		  case RC_3:
		  	LCDPrintf("3\n");
		  	v = STD_V;
		   	d = DEG2RAD * -45;
			  break;
	  	case RC_4: 
	  		LCDPrintf("4\n");
	  		v = STD_V;
	  		d = DEG2RAD * 90;
	  		break;
	  	case RC_5: 
	  		LCDPrintf("5\n");
	  		v = 0;
	  		break;
	  	case RC_6: 
	  		LCDPrintf("6\n");
	  		v = STD_V;
	  		d = DEG2RAD * -90;
	  		break;
	  	case RC_7: 
	  		LCDPrintf("7\n");
	  		v = STD_V;
        d = DEG2RAD * 135;
			  break;
      case RC_8: 
		  	LCDPrintf("8\n");
		  	v = STD_V;
		  	d = DEG2RAD * 180;
		  	break;
	  	case RC_9: 
	  		LCDPrintf("9\n");
	  		v = STD_V;
	  		d = DEG2RAD * -135;
	  		break;
	  	case RC_FF:
	  		LCDPrintf("FF\n");
	  		w = -STD_W;
	  		break;			
	  	case RC_RW:
	  		LCDPrintf("RW\n");
	  		w = STD_W;
	  		break;			
	  	case RC_PLAY:
	  		LCDPrintf("Play\n");
	  		v = STD_V;
	  		d = 0;			
	  		break;
	  	case RC_STOP:
	  		LCDPrintf("Stop\n");
	  		v = 0;
	  		w = 0;
	  		break;
	  	case RC_OK:
	  		LCDPrintf("OK\n");
	  		w = 0;
	  		break;			
	  	case RC_STANDBY:
	  		LCDPrintf("Standby\n");
	  		terminated = 1;
	  		break;
	  	default:
	  		LCDPrintf("unhandled: %4x\n", code);			
		}
		OMNI_SetSpeed(vw, v, d, w);
	}
	OMNI_Release(vw);
	IRTVTerm();
}

