/***********************************************************************/
/** @name driveglobal.h 
    @author Birgit Graf, UWA, 1998, modified 2000 (Mk3/4)
*/
/***********************************************************************/

/*@{*/


#include "global.h"

/** Say whether player is goalkeeper */
int I_am_goalie();


/** Init VW interface.
 */
void Init_Drive();

/** Stop VW interface.
*/
void End_Drive();

/** Change parameters for driving.
 */
void set_drv_parameters();

/** Print robot position.
    Print x- and y-coordiantes in cm and orientation in degrees on LCD.
*/
void print_pos();

/** Set robot position.
    Interface function to vw.
*/
void set_pos(meter x, meter y, radians phi);

/** Return robot position in referenced parameter.
    Interface function to vw.
*/
void get_pos(PositionType* req_pos);

/** Set robot coordinates.
    Set robots x and y positions. (0,0) = middle of own goal,
    looking towards opponents goal, y goes positive to left,
    x positive forwards, angle is positive to right, negative to left.
*/
void set_coordinates();

/** Stop.
    Interface function to vw.
*/
void drive_stop();

/** Did robot wheels stall?
    Interface function to vw.
*/
int wheels_stalled();

/*@}*/
