/***********************************************************************/
/** @name global.c   
    Contains global definitions and variables which are used by the
    different program components to communicate data and results.
    
    @author Thomas Braunl, Birgit Graf, UWA, 1998, modified 2000 (Mk3/4)

*/
/***********************************************************************/

/*@{*/

#include "global.h"


/** flag to indicate current camera position, set after
    camera movement (used by servos.c and image.c) */
int cam_pos = 0;  

/* ----= flags to indicate results of sensor readings  =---- */
/** flag to indicate keypress (-> end ball search) */
int end_flag = FALSE;

/** flag to indicate detected object */
int obstacle_flag = FALSE;

/** flag to indicate having ball caught in front of robot.
		Set by image.c and drive.c, read by drive.c
 */
int got_ball_flag = FALSE;

/** flag to indicate seing ball.
		Set by image.c and drive.c (set false if all is lost, e.g. after turn),
		read by drive.c, sensors.c, soccer.c
 */
int see_ball_flag = FALSE;

/** flag to indicate that program just started */
int start_flag = TRUE;
int start_flag1 = TRUE;
int attack_flag = FALSE;

/** flag for competition mode */
int competition_mode = FALSE;		
  
/** position of player */
int player_pos = 0;

/** next home position */
int next_home = 0;


/*@}*/

