/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-29
 */

#ifndef _angles_h
#define _angles_h

#include <math.h>

/****f* soccer-pere/rad2deg
 * SYNOPSIS
 *   float rad2deg(float rad)
 * DESCRIPTION
 *   Convert from radians to degrees.
 ****/
static __inline__ float
rad2deg(float rad)
{
  return rad*180/M_PI;
}

/****f* soccer-pere/deg2rad
 * SYNOPSIS
 *   radians deg2rad(float d)
 * DESCRIPTION
 *   Convert from degrees to radians
 ****/
static __inline__ float
deg2rad(float d)
{
  return d*M_PI/180;
}

/****f* soccer-pere/rad2rad
 * SYNOPSIS
 *   float rad2rad(float rad)
 * DESCRIPTION
 *   Make sure the angle given is in the range -M_PI to M_PI.
 ****/
static __inline__ float
rad2rad(float rad)
{
  if (rad < -M_PI)
    rad += 2*M_PI;
  if (rad > M_PI)
    rad -= 2*M_PI;
  return rad;
}

#endif
