#include <eyebot.h>
#include <picture.h>
#include <picproc.h>

#include <string.h>
#include <stdlib.h>

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))

const int bwrows = 64;
const int bwcolumns = 128;

/****f* soccer-pere/draw_graph
 * DESCRIPTION
 *   Draw a dot-graph in the given image using set_pixel_white().  The
 *   given values are read as a circular buffer with the first value
 *   at values[startpos], and with numvalues in the circular buffer.
 ****/
void
draw_graph(Picture *img, int values[], int startpos, int numvalues,
	   int minval, int maxval)
{
  int toprow    = 20*img->height/100; /* 20 % from the top */
  int bottomrow = 80*img->height/100; /* 80 % from the top */
  int white = 0x00ffffff;

  /* Draw lines limiting graph */
  for (int col = 0; col < img->width; col++)
    {
      picproc_drawPixel(img, col, toprow, white);
      picproc_drawPixel(img, col, bottomrow, white);
    }
  int endpos = (startpos + numvalues - 1) % numvalues;
  int col = 0;

  int span = maxval - minval;
  if (0 == span)
    span = 2;

  for (int pos = startpos; pos != endpos; pos = (pos + 1) % numvalues)
    {
      double val = (values[pos] - minval)*1.0 / span;
      int row = bottomrow - (int) ((bottomrow - 2 - toprow - 2) * val);
      picproc_drawPixel(img, col, row, white);
      col++;
    }
}

/****f* soccer-pere/audio_test
 * DESCRIPTION
 *   Sample from microphone, and display the readouts as a scrolling
 *   graph on the LCD display.
 ****/
int
audio_test(void)
{
  int samplerate = 5; /* 1/100 seconds between samples */
  int bufpos = 0;
  int *audio_buffer;
  /* Samples are 10 bit, initialize min and max */
  int minlevel = (1 << 10) - 1;
  int maxlevel = 0;

  if (0 == audio_buffer)
    {
      LCDPutString("AU buffer alloc\nfailed!\n");
      return -1;
    }

  Picture *img;
#ifdef __mc68000__
  img = picture_new(bwcolumns, bwrows, pix_bitmap);
#else
  img = picture_new(imagecolumns, imagerows, pix_rgb24);
#endif

  audio_buffer = new int[img->width];
  memset(audio_buffer, 0, img->width * sizeof(*audio_buffer));

  LCDClear();
  LCDMenu(" ", " ", " ", "END");
  while (KEY4 != KEYRead())
    {
      int level = AUCaptureMic();
      LCDSetPrintf(1, 0, "L: %4d P: %3d\n", level, bufpos);
      minlevel = MIN(minlevel, level);
      maxlevel = MAX(maxlevel, level);
      audio_buffer[bufpos] = level;
      bufpos = (bufpos + 1) % img->width;

      picture_clear(img);
      draw_graph(img, audio_buffer, bufpos, img->width,
		 minlevel, maxlevel);


#ifdef __mc68000__
      // Broken in simulator */
      LCDPutImage(img->data);
#else
      LCDPutColorGraphic((colimage*)img->data);
#endif

      OSSleep(samplerate);
    }
  picture_delete(img);
  return 0;
}

#if TEST
int
main()
{
  audio_test();
  free(malloc(1));
  return 0;
}
#endif
