/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date: 2000-08-15
 *
 * Time how long a block takes to execute.
 */
#ifndef _blocktimer_hh
#define _blocktimer_hh

#include <string.h> /* for strncpy() */
#if defined(__mc68000__)
#include <eyebot.h>
#include "debug.h"
#else
#include <sys/time.h>
#include <unistd.h>
#endif

class BlockTimer
{
  char title[100];
  int start;
  static int getTimestamp(void)
  {
#if defined(__mc68000__)
    return OSGetCount();
#else
    static bool isfirsttime = true;
    static struct timeval firsttime;
    struct timeval nowtime;
  
    gettimeofday(&nowtime, NULL);
    if (isfirsttime)
      {
	firsttime = nowtime;
	isfirsttime = false;
      }

    return (nowtime.tv_sec * 100 + nowtime.tv_usec / 10000
	    - firsttime.tv_sec * 100 - firsttime.tv_usec / 10000);
#endif
  }
public:
  BlockTimer(const char *_title) : start(getTimestamp())
  {
    strncpy(title, _title, sizeof(title));
    title[sizeof(title)-1] = '\0';
#if 0
    mydebug("BT:%s: starting", title);
#endif
  };
  ~BlockTimer()
  {
    int now = getTimestamp();
    int used = now - start;
    mydebug("BT:%s: %d.%02d s used", title, used / 100, used % 100);
  };
};

#define TIMEBLOCK() BlockTimer _line_ ## __LINE__ (__FUNCTION__)

#endif /*  _blocktimer_hh */
