/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 * Test CMVision on the Soccer Eyebot.
 */

#include <eyebot.h>

#include "camera.hh"
#include "cmvision.h"
#include "picproc.h"

extern "C" int rgb2yuyv(Picture *dest_img, Picture *src_img);

/* Make 3^3 = 27 color classes with equal volum */
void
make_color_classes(CMVision *classifier)
{
  int step = (CMV_COLOR_LEVELS-1) / 3;
  int color_id = 0;

  if (NULL == classifier)
    return;

  LCDPutString("init cl");
  for (int y = 0; y < CMV_COLOR_LEVELS-1; y += step+1)
    for (int u = 0; u < CMV_COLOR_LEVELS-1; u += step+1)
      for (int v = 0; v < CMV_COLOR_LEVELS-1; v += step+1)
	{
	  classifier->setThreshold(color_id,
				   y, y + step,
				   u, u + step,
				   v, v + step);
	  color_id++;
	}
  LCDPutString(" - ok\n");
}

int
LCDBox(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, 
       int color)
{
  LCDLine(x1,y1,x1,y2, color);
  LCDLine(x1,y1,x2,y1, color);
  LCDLine(x1,y2,x2,y2, color);
  LCDLine(x2,y1,x2,y2, color);
  return 0;
}

/****f* soccer-pere/cmvision_test
 * DESCRIPTION
 *   Test CMVision on the Eyebot, drawing boxes around the regions
 *   found.
 *****/
int
cmvision_test(Camera *framegrabber)
{
  int framecount = 0;
  bool laststate;     /* Initial state of the frame rate calculation */

  CMVision *classifier = new CMVision();
  classifier->initialize(imagecolumns, imagerows);

  Picture yuyv_frame;
  picture_init(&yuyv_frame, imagecolumns, imagerows, pix_yuyv, 0,
	       new BYTE[imagecolumns * imagerows * 2],
	       imagecolumns * imagerows * 2);

  make_color_classes(classifier);

  laststate = framegrabber->framerateOn(true);

  LCDClear();
  LCDSetString(0, 10, "CM-");
  LCDSetString(1, 10, "Vision");
  LCDSetString(3, 10, "FPS:");
  LCDSetString(5, 10, "Count:");
  LCDMenu(" ", " ", " ", "END");

  while (KEY4 != KEYRead()) {
    colimage testimage;
    Picture *frame = framegrabber->capture();
    framecount++;

    if (NULL != frame)
      rgb2yuyv(&yuyv_frame, frame);

    if (NULL == frame
	|| !classifier->testClassify((struct rgb*)&testimage[0][0][0],
				     (struct yuv422 *)yuyv_frame.data))
      {
	LCDPrintf("Error processing image #%d 0x%x\n", framecount, frame);
      }
    else {
      LCDArea(0,0,imagecolumns-1, imagerows-1, 0);
      LCDPutColorGraphic(&testimage);
      for (int color_id = 0; color_id < CMV_MAX_COLORS; color_id++)
	{
	  for (CMVision::region *reg = classifier->getRegions(color_id);
	       NULL != reg; reg = reg->next)
	    {
	      LCDBox(reg->x1, reg->y1, reg->x2, reg->y2, 2);
#if 0
	      LCDPrintf(" #%d (%d,%d) %d\n", color_id,reg->x1, reg->y1,
			reg->area);
#endif
	    }
	}
    }
    LCDSetPrintf(4,10, "%5.2f", framegrabber->getFramerate());
    LCDSetPrintf(6,10, "%05d", framecount);
  } /* while (KEY4 != KEYRead()) */

  delete classifier;

  framegrabber->framerateOn(laststate);

  return 0;
}
