#include <eyebot.h>
#include <parselanguage.h>

#include <stdio.h>
#include <stdarg.h>

#include "debug.h"

static int ser_interface = SERIAL1;
static lang_channel channel = -1;

int
mydebug_init(void)
{
  return OSInitRS232( SER115200, NONE, ser_interface );
}

int
mydebug_set(int iface, lang_channel ch)
{
  if (-1 != iface && iface != ser_interface)
    {
      mydebug_release();
      ser_interface = iface;
      mydebug_init();
    }

  if (0 != channel)
    channel = ch;

  return 0;
}

void
mydebug_release(void)
{ /* It is not possible to stop RS232 communication. */
}

/****f* soccer-pere/debug
 * DESCRIPTION
 *   Send string over serial connection and radio.
 ****/
void
mydebug(const char format[], ...)
{
#if defined(NDEBUG)
  return;
#else
  va_list ap;
  int retval = 0;
  char strbuf[100];

  if (NULL == format)
    return;

  va_start(ap, format);
  retval = vsprintf(strbuf, format, ap);
  va_end(ap);
  {
    int pos = 0;
    while (strbuf[pos])
      OSSendRS232(&strbuf[pos++], ser_interface);
    OSSendCharRS232('\n', ser_interface);
  }

  /* Send it over the radio as well. */
  {
    langEventText event;

    event.type = langTypeText;
    event.to = 0; /* PC */
    event.timestamp = OSGetCount();

    event.file = langTextFileLog;
    event.length = retval+1;
    event.data = &strbuf[0];

    lang_send(channel, (langEvent*)&event);
  }
#endif
}
