/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-06
 *
 * Wrapper for drive routines on the Eyebot.
 */

#ifndef _driver_hh
#define _driver_hh

#include <eyebot.h>

#include "vec2d.hh"

class Driver
{
public:
  Driver(void);
  ~Driver();
  bool initialize(void);
  const PositionType & getPosition(void);
  void setPosition(const PositionType &pos);

  const vec2d getPosition(radians *heading);
  void setPosition(const vec2d &pos, radians heading);

  double getDriveSpeed(void) const { return drivespeed; };
  double getTurnSpeed(void) const { return turnspeed; };

  void setDriveSpeed(double speed) { drivespeed = speed; };
  void setTurnSpeed(double speed) { turnspeed = speed; };

  bool isStalled(void);

  bool isStanding(void);
  void waitUntilStanding(void);

  meter getRemaining(void);

  void turn(radians rotation);
  void straight(meter distance);
  void curve(meter distance, radians rotation);

  void path(PositionType *targets, int numtargets);

  bool start(void);
  void stop(void);
private:
  VWHandle wheels;
  PositionType curpos;

  int started;

  double drivespeed;
  double turnspeed;
};

#endif
