/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-08-19
 */

#ifndef _evidencemap_hh
#define _evidencemap_hh

#include <limits.h>
#include "soccerfield.h"
#include "psdbeam.h"

/* resolution in mm */
#define MAPRESOLUTION 100

class EvidenceMap
{
  enum
  {
    mapcols    = 5*FIELD_WIDTH_Y / (2*MAPRESOLUTION),
    stmapcount = 4,

    empty      = 0,
    unknown    = UCHAR_MAX / 2,
    occupied   = UCHAR_MAX
  };
  typedef BYTE cell_t;
  typedef cell_t map_t[mapcols][mapcols];
  map_t ltmap;             /* long term map */
  map_t stmap[stmapcount]; /* short term maps */

  unsigned int stcurrent;
  int compareCells(const cell_t c1, const cell_t c2);
  void clearSTMap(void);
  void addSTMapCellValue(unsigned int stmapid, int x, int y, cell_t value);
  void addPSDLine(unsigned int stmapid, int c1, int r1,
		  int c2, int r2, bool m);

  void drawInitialMap(void);

public:
  EvidenceMap();

  void addPSDReading(const psdbeam_t &reading);

  int compare(const map_t &nmap, int tcolumn, int trow, int trotation);

  bool matchMatureMap(vec2d *delta, radians *phidelta);

  void saveMap(const char *filename, const map_t &nmap);
  const map_t &getLongTermMap(void) { return ltmap; };
};

#endif /* _evidencemap_hh */
