/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-08-20
 */

#ifndef _fieldmap_hh
#define _fieldmap_hh

#include "vec2d.hh"
#include "segment2d.hh"

class FieldMap
{
public:
  static const vec2d * getCorners(unsigned int *cornercount);
  static const segment2d *getMap(unsigned int *numsegments);

  static bool isOnField(vec2d pos);

  static vec2d &getBlueGoalCenter(void);
  static vec2d &getYellowGoalCenter(void);
private:

  static void makeSegments(segment2d walls[], unsigned int wallcount,
			   const vec2d corners[], unsigned int cornercount);
};

#endif /* _fieldmap_hh */
