/* Private Camera HDT entry for soccer 2000 player */

#ifndef _hdtcamera_h
#define _hdtcamera_h

#include <eyebot.h>
#include <math.h>

typedef struct
{
  int version;
  DeviceSemantics servo;
  BYTE center;      /* servo center setting (looking forward) */
  radians rotation; /* Servo rotation range */
  radians view;  /* camera horizontal view angle */
} camera_pan_type;

#define CAMERA    -2000 /* Type */
#define CAMERAPAN -2001 /* semantics */

#define PSDPOS_HOR   -3001 /* semantics */

#define DEG2RAD(d) (M_PI*(d)/180.0)

#endif /* _hdtcamera_h */
