/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-10
 *
 * Hide IR and key input.
 */

#include <irtv.h>
#if defined(__mc68000__)
#include <IRnokia_vcn620.h>
#endif

#include <eyebot.h>

static int inputusers = 0;

int
inputInit(void)
{
  inputusers++;

  IRTVInit(SPACE_CODE, 15, 0, 0x3FF, SLOPPY_MODE, 4, 300);
  return 0;
}

int
inputRead(void)
{
  int key = KEYRead();
  if (!key)
    {
      int irkey = IRTVRead();
      switch (irkey)
        {
#if defined(__mc68000__)
        case RC_RED:
          key = KEY1;
          break;
        case RC_GREEN:
          key = KEY2;
          break;
        case RC_YELLOW:
          key = KEY3;
          break;
        case RC_BLUE:
          key = KEY4;
          break;
#endif
        default:
          key = irkey;
          break;
        }
    }
  return key;
}

int
inputGet(void)
{
  int key;
  while (0 == (key = inputRead()))
    OSSleep(1);
  return key;
}

int
inputGetBuf(char *buf)
{
  if (0 == buf)
    return -1;
  *buf = inputGet();
  return 0;
}

int
inputWait(int key)
{
  if (ANYKEY == key)
    return inputGet();

  while (key != inputGet())
    OSSleep(1);
  return key;
}

int
inputRelease(void)
{
  if (0 == --inputusers)
    IRTVTerm();
  return 0;
}
