//#include <string.h>

#include "picproc.h"
#include "parselanguage.h"

#include "robotcontrol.hh"
#include "keeper.hh"
#include "soccer.hh"
#include "debug.h"
#include "soccerfield.h"
#include "vec2d.hh"
#include "vision.h"
#include "camera.h"
#include "envstatus.hh"
#include "angles.h"

#define POWER_LIMIT 900

bool keeper::decide(void)
{
  const int goaloffset = 180;
  const int timestep = 100; /* n/100 seconds between decisions */
  
  /* Where are we going now */
  vec2d respos;
  radians resheading;
  
  vec2d ourgoalcenter = status->getOurGoalCenter();

  radians myheading;
  vec2d mypos         = status->getMyCurrentPos(&myheading);
  mydebug("mypos.x: %d mypos.y: %d",mypos.x, mypos.y);
  vec2d ballpos       = status->getBallCurrentPos();
  resheading = myheading;

  if(ballpos.x <= -goaloffset) /* stay in the goal */
    {
      respos.x = -goaloffset;
      mydebug("respos.x: %d",respos.x);
    }
  else if(ballpos.x >= goaloffset)
    {
      respos.x = goaloffset;
      mydebug("respos.x: %d",respos.x);
    }
  else 
    {
      respos.x = ballpos.x;
      mydebug("respos.x: %d",respos.x);
    }
  
  respos.y = mypos.y; /* XXX stay on the goalline. Should be changed
                         to check whether we're still on the line or
                         not. */
  mydebug("respos.y: %d",respos.y);

  /* Always look at the ball XXX*/
  /* status->pancamera.setHeading(toball.heading() - myheading); */
  
  if (lastdecision + timestep > status->lastupdate)
    return true;
  lastdecision = status->lastupdate;
  
  driveTo(respos, resheading);
  return true;
}

void keeper::driveTo(const vec2d &newpos, radians endheading)
{
  /* Make it possible to draw line to where we are going */
  status->setDestPoint(newpos);
  
  Driver *driver = status->driver;
  
  radians myheading;
  vec2d mypos = status->getMyCurrentPos(&myheading);
  
  if (EnvStatus::pause == status->gamestatus)
    return;

  meter distance = (newpos.x - mypos.x)/1000.0;
  if(0 == distance)
    return;

  if(status->goal_at_top) /* defending yellow goal */
    driver->straight(distance);
  else /* defending blue goal */
    driver->straight(-distance);
}





