/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 * Soccer field self-localization using distance sensors and panning camera.
 */

#include <eyebot.h>

#include "camera.hh"
#include <parselanguage.h>

#include "scrollmenu.hh"
#include "driver.hh"
#include "debug.h"

#include "soccer.hh"
#include "vision.h"
#include "input.h"

struct env
{
  lang_channel channel;
  Camera *framegrabber;
  Driver *drive;
};

#if defined(USE_CMVISION)
void
cmvision_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  cmvision_test(myenv->framegrabber);
}
#endif

void
libvision_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  VIS_Soccer_test();
}

#if 0
void
audio_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  audio_test();
}
#endif

void
pan_pos_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  pan_pos_test(myenv->framegrabber, myenv->drive);
}

#if 0
void
global_id_find_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  findGlobalId(myenv->channel, myenv->drive);
}
#endif

void
panning_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  test_panning();
}

void
play_ball_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  play_ball(myenv->channel, myenv->framegrabber, myenv->drive);
}

void
find_timediff_cb(scrollmenu *menu, void *data, int direction)
{
  struct env *myenv = (struct env *)data;
  find_timediff_test(myenv->channel);
}

int
main()
{
  mydebug("main()");

  struct env myenv;
  scrollmenu menu;
  Driver drive;

  if (!menu.initialize("Pere Soccer"))
    {
      LCDPrintf("menu init failed");
    }

  mydebug("Showing menu");

  menu.show();

  menu.addEntry("Play ball",      play_ball_cb,      (void*)&myenv);
  menu.addEntry("Timediff tst",   find_timediff_cb,  (void*)&myenv);
#if defined(USE_CMVISION)
  menu.addEntry("CMVision",       cmvision_cb,       (void*)&myenv);
#endif
  menu.addEntry("libvision",      libvision_cb,      (void*)&myenv);
#if 0
  menu.addEntry("Audio",          audio_cb,          (void*)&myenv);
#endif
  menu.addEntry("Pan-Pos",        pan_pos_cb,        (void*)&myenv);
#if 0
  menu.addEntry("Find global id", global_id_find_cb, (void*)&myenv);
#endif
  menu.addEntry("Pan test",       panning_cb,        (void*)&myenv);

  if (!drive.initialize())
    {
      LCDPrintf("No wheels present\n");
      myenv.drive = 0;
    }
  else
    myenv.drive = &drive;
    
  inputInit();

  myenv.channel = lang_init();

  mydebug_init();

  if (0 == myenv.channel)
    mydebug("lang_init() failed");
  else
    {
      mydebug_set(-1, myenv.channel);
      mydebug("lang_init() ok");
    }

  myenv.framegrabber = Camera::newCamera(imagecolumns, imagerows, pix_rgb24);
  if (NULL == myenv.framegrabber)
    mydebug("Camera init failed");
  else
    mydebug("Camera initialized");

  menu.exec();

  lang_release(myenv.channel);
  mydebug_release();

  delete myenv.framegrabber;

  inputRelease();

  return 0;
}
