/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-06-07
 *
 * Drive in a square to measure the odometry error, as described by
 * Borenstein and Feng.
 */

#include <eyebot.h>

#include <math.h>
#include "driver.hh"
#include "input.h"

const char *
directionString(int direction)
{
  return direction > 0 ? "left" : "right";
}

void print_pos(Driver *drive)
{
  const PositionType pos = drive->getPosition();
  LCDSetPrintf(3, 0, "Pos:%4.2fx%4.2f", pos.x, pos.y);
  LCDSetPrintf(4, 0, "Heading:%5.1f", (pos.phi * 180.0 / M_PI));
}

void
drive_square(int direction, meter distance)
{
  Driver *drive = new Driver();
  PositionType center = {0,0,0};
  int i;

  LCDClear();
  LCDPrintf("Driving %s \nin a square...\n", directionString(direction));
  LCDMenu(" ", " ", " ", "END");

  drive->setPosition(center);
  for (i=0; KEY4 != KEYRead() && i < 8; i++)
    {
      if (0 == (i % 2))
	drive->straight(distance);
      else
	drive->turn(direction * M_PI_2);
      while (KEY4 != KEYRead() && !drive->isStanding())
        {
          print_pos(drive);
          OSSleep(5);
        }
    }
  print_pos(drive);
  delete drive;
}

void
print_config(int direction, meter distance)
{
  LCDSetPrintf(3,0, "Direction: %s \n",  directionString(direction));
  LCDSetPrintf(4,0, "Distance:  %5.2f \n", distance);
}

void
main_show_menu(int direction, meter distance)
{
  LCDClear();
  LCDPutString("Odometry test\n");
  print_config(direction, distance);
  LCDMenu("+", "-", "Dir", "Go");
}

int
main()
{
  bool running = true;
  int key = ANYKEY;
  int direction   = -1; /* turn right */
  meter distance  = 1.0; /* meter */
  main_show_menu(direction, distance);
  while (running)
    {
      key = KEYRead();
      switch (key) {
      case KEY1:
        distance += 0.05;
        print_config(direction, distance);
        break;
      case KEY2:
        distance -= 0.05;
        if (0 > distance)
          distance = 0.0;
        print_config(direction, distance);
        break;
      case KEY3:
        direction = -direction;
        print_config(direction, distance);
        break;
      case KEY4:
	OSSleep(300); /* 3 seconds to remove hand */
	drive_square(direction, distance);

	LCDMenu("CONT", " ", " ", "EXIT");

	key = KEYGet();
	if (KEY4 == key)
	  running = false;
	else
	  main_show_menu(direction, distance);
	break;
      }
    }

  return 0;
}
