/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-08-09
 */

#ifndef _panning_hh
#define _panning_hh

#include <eyebot.h>

/****c* soccer-pere/Panning
 * DESCRIPTION
 *   Wrapper class for a panning platform.  Keeps track of current
 *   angle, and if the platform is stable or not (finished turning).
 ****/
class Panning
{
private:
  BYTE servoval; /* current servo setting */
  int handle;    /* servo handle */
  int ready;     /* Timestamp when the camera will be finished turning */
  int center;    /* servo setting when the camera is looking forward */
  radians radperval;
  /* How long does it take to do a complete rotation */
  static const int ticperturn;
public:
  Panning(void) : servoval(255/2), handle(0), ready(0),
		  center(255/2), radperval(1) {};
  ~Panning();
  bool initialize(DeviceSemantics servoid);

  void setCenter(BYTE v);
  void setRotation(radians r);

  void setServo(BYTE v);
  BYTE getServo(void);

  bool setHeading(radians r);
  radians getHeading(void);

  bool isRotating(void);
};

#endif /* _panning_h */
