/*
  demo.cc

  Demo code for CMVision. Use this to learn stuff.
  Author: Ziauddin Khan <zkhan@cs.cmu.edu>
      ,_      _,
        '.__.'
   '-,   (__)   ,-'
     '._ .::. _.'
       _'(^^)'_
    _,` `>\/<` `,_
   `  ,-` )( `-,  `
      |  /==\  |
    ,-'  |=-|  '-,
         )-=(
jgs      \__/

  Revision History:
  3-30-00, Initial release.

 */ 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdio.h>

#include "angles.h"
#include "posviewer.hh"
#include "parselanguage.h"

// check if there are X-Windows events waiting 
bool eventsPending(Display *display)
{
  if (0 == XPending(display))
    return false;
  else 
    return true;
}

int
lang_handler(langEvent *event, void *ref)
{
  if (NULL == event || NULL == ref)
    return -1;
  PosViewer *pview = (PosViewer*)ref;
  switch (event->type)
    {
    case langTypeTrack:
      {
        langEventTrack *track = (langEventTrack *)event;
	pview->setPosition(track->from, track->name, 
			   track->num, track->timestamp,
			   vec2d(track->x, track->y),
			   lang_angle2rad(track->heading));
	break;
      }
    }
}


// main, main, lalala 
int
main(int argc, char**argv)
{
  char *display_name = NULL;
  Display *display;
  int screen_num;

  int channel;

  channel = lang_init();
  if (0 == channel)
    {
      fprintf(stderr, "lang_init() failed\n");
      return -1;
    }

  printf("\nReady to receive coordinates\n");

  // connect to X server
  if ((display=XOpenDisplay(display_name)) == NULL)
    {
      fprintf(stderr,"cannot connect to X server, doh! xserver is --> %s\n",
	      XDisplayName(display_name)); 
      exit(-1);
    }
  screen_num = DefaultScreen(display);

  PosViewer posviewer(display, screen_num);
  posviewer.showWindow();
#if 1
  posviewer.setPosition(1, langNameFriend, 1, 1, vec2d(200,400), M_PI);
  posviewer.setPosition(2, langNameFriend, 2, 1, vec2d(0,0), M_PI_2);
  posviewer.setPosition(2, langNameBall,   0, 1, vec2d(0,200), 0.0);
#endif
  // main event loop
  XEvent report;
  while (1)
    {
      if (lang_messageWaiting(channel))
        lang_receive(channel, lang_handler, &posviewer);
      if (eventsPending(display))
	{
	  XNextEvent(display, &report);
	  // let the window(s) deal w/ events first
	  if (!posviewer.handleEvent(report))
	    { 
	      switch (report.type)
		{ // then, we'll deal with it
		case ButtonPress: // exit on key or button press
		case KeyPress:
		  XCloseDisplay(display);
		  lang_release(channel);
		  exit(1);
		  break;
		}
	    }
	}
      posviewer.update();
      // update window(s)
    }
  lang_release(channel);
  return 0;
}
