#ifndef __posviewer__hh__
#define __posviewer__hh__

#include "XWindow.hh"
#include "vec2d.hh"

class PosViewer : public XWindow{
public:
  typedef struct {
    int timestamp;
    unsigned char from;
    vec2d pos;
    float heading;
  } Position;
protected:
  int border;
  double scale;
  enum { POSITIONS = 10 };
  Position position[3][POSITIONS];
  color_t colorBlack, colorWhite, colorRed, colorBlue, colorGreen;
  vec2d mappos(const vec2d &p);
  int getNameIndex(int name);
public:
  PosViewer(Display *d, int s);
  ~PosViewer();
  void update();
  void paint();
  void showWindow();
  bool handleEvent(XEvent &report);

  void setPosition(unsigned char from, int name, unsigned char id,
		   int timestamp, const vec2d &pos, float heading);
};

#endif
