/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-06-14
 */

#include "predictor.hh"
#include "parselanguage.h"
#include <stdio.h>
#include <math.h>
#include "debug.h"

Predictor::Predictor()
  
{
  last.timestamp = 0;
  last.pos.x = 0;
  last.pos.y = 0;
  last.dpos.x = 0;
  last.dpos.y = 0;
  last.heading = 0;
  last.velocity = 0;
  last.acceleration = 0;
}

void
Predictor::newPosition(vec2d *pos, int timestamp)
{
  if (0 == last.timestamp)
    { /* First time */
      last.timestamp = timestamp;
      last.pos = *pos;
      return;
    }

  /* All others; */
  ObjectStatus newstatus;
  newstatus.pos = *pos;
  newstatus.timestamp = timestamp;
  newstatus.dpos = newstatus.pos-last.pos;

  vec2d davg = (last.dpos+newstatus.dpos)/2;

  int dtime        = timestamp-last.timestamp;
  int heading      = lang_rad2angle(davg.heading());
  double ddistance = davg.length();

  double velocity  = ddistance*1000.0/dtime;

  /* Do a running average */
  if (ddistance > 0.0001)
    newstatus.heading      = (int)(heading * 0.5 + last.heading * 0.5);
  else
    newstatus.heading = last.heading;
  newstatus.velocity     = (int)(velocity * 0.1 + last.velocity * 0.9);

  newstatus.acceleration = (newstatus.velocity-last.velocity)*1000/dtime;

  // memcpy(&last,&newstatus, sizeof(last));
  last = newstatus;
#if 0
  printf("PN: %08x head=%4d vel=%4d acc=%4d t=%d diff: %4d %4d %4d\n",
	 (int)this,
	 last.heading,
	 last.velocity,
	 last.acceleration,
	 last.timestamp,
	 dpos.x, dpos.y, dtime);
#endif
}

/* Linear prediction */
ObjectStatus *
Predictor::getStatus(int timestamp)
{
  if (0 == last.timestamp)
    return NULL;

  if (timestamp == last.timestamp)
    return &last;

  mydebug("Bogus predicted status returned!\n");

  return &last;
}

/* *****************************************
 ** Make class available from C as well. **
 * **************************************** */

#if defined(__mc68000__)
PredictorRef
Predictor_new(void)
{
  return new Predictor();
}

void
Predictor_delete(PredictorRef ref)
{
  Predictor *p = (Predictor *)ref;
  delete p;
}
#endif

void
Predictor_newPosition(PredictorRef ref, vec2d *pos, int timestamp)
{
  Predictor *p = (Predictor *)ref;
  p->newPosition(pos, timestamp);
}

ObjectStatus *
Predictor_getStatus(PredictorRef ref, int timestamp)
{
  Predictor *p = (Predictor *)ref;
  return p->getStatus(timestamp);
}
