/*
 * C API to interface with predictor class
 */

#ifndef _predictor_c_h
#define _predictor_c_h

#include "vec2d.hh"

#ifdef __cplusplus
extern "C" {
#endif

typedef void * PredictorRef;

typedef struct
{
  int timestamp;    /* 1/1000 second */
  vec2d pos;
  vec2d dpos;       /* Position displacement ending up in pos */
  int heading;      /* 0-3600 degrees*10 */
  int velocity;     /* mm/second */
  int acceleration; /* mm/second^2 */
} ObjectStatus;

#if defined(__mc68000__)
PredictorRef Predictor_new(void);
void Predictor_delete(PredictorRef ref);
#endif

void Predictor_newPosition(PredictorRef ref, vec2d *pos, int timestamp);
ObjectStatus *Predictor_getStatus(PredictorRef ref, int timestamp);


#ifdef __cplusplus
}
#endif

#endif /* _predictor_c_h */
