/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 * Wrapper class for PSD distance sensors.
 */

#include "psd_sensor.h"

/*
 * Initialize and start PSD sensor
 */
psd_sensor::psd_sensor(DeviceSemantics sematics)
{
  handle = PSDInit(semantics);
  if (0 == handle)
    throw new no_such_sensor("PSD missing");
  angle = 0; /* XXX find angle */

  if (0 != mask)
    PSDStop();
  mask |= handle;
  if (-1 == PSDStart(mask, TRUE))
    cerr << "Unable to start PSD measurement with mask " << mask << endl;
}

/*
 * Check if there is new values available for this sensor.  Get
 * measurement if one is available, and record time this was sensed.
 */
void
psd_sensor::sense(void)
{
  if (PSDCheck())
    {
      int newtime = PSDGet(0);
      if (newtime > senseStamp())
	{
	  distance = PSDGet(handle);
	  super.sense();
	}
    }
};

static psd_sensor[]
psd_sensor::activate_all(void)
{
  int psd_count = 0;
  psd_sensor **psd;
  psd_sensor *psd;
  int i = 0;
  while (0 != sensors[i])
    try {
      psd = new psd_sensor(sensors[i]);
      if (NULL != psd)
	{
	  psd_sensor = new[] psd_sensor*;
	}
    } catch (no_such_sensor &ex) {}
}
