/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 * Wrapper class for PSD distance sensors.
 */
#include <eyebot.h>
#include "sensor.h"

class psd_sensor : public sensor
{
  radians angle;
  PSDHandle handle;

  int distance;

  static PSDHandle mask = 0;

  static DeviceSemantics sensors[] =
  {
    PSD_FRONT, PSD_FRONT2,
    PSD_FRONTLEFT, PSD_FRONTRIGHT,
    PSD_LEFTDIAG, PSD_RIGHTDIAG,
    PSD_LEFT, PSD_RIGHT, PSD_BACK,
    PSD_TEST,
    0
  };
 public:
  psd_sensor(DeviceSemantics sematics);
  void sense(void);
  static psd_sensor *activate_all(void);
}
