#include <eyebot.h>

/****f* soccer-pere/getPSDRange
 * SYNOPSIS
 *   int getPSDRange(DeviceSemantics *psdsem, int *min, int *max)
 * DESCRIPTION
 *   Return range of given PSD sensor.  Assumes a well-formed PSD
 *   distance mapping table.
 * EXAMPLE
 *   int min, max;
 *   if (0 != getPSDRange(PSD_FRONT, &min, &max))
 *   {
 *      printf("getPSDRange() failed\n");
 *   }
 * AUTHOR
 *   Petter Reinholdtsen <pere@td.org.uit.no>
 ****/
int
getPSDRange(DeviceSemantics psdsem, int *min, int *max)
{
  const int tablesize = 128;
  short *table;
  int pos = 0;

  psd_type *psd_info = (psd_type*)HDTFindEntry(PSD, psdsem);

  if (NULL == psd_info || NULL == psd_info->dist_table) /* Unknown PSD */
    return -1;

  table = psd_info->dist_table;

  /* First value is the lowest distance measured */
  *min = table[0];

  /* Find the first PSDMaxRange value in the table */
  while (pos < tablesize &&
         PSD_OUT_OF_RANGE != table[pos])
    pos++;

  /* Read maximum distance */
  *max = table[pos-1];

  return 0;
}
