/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 */

#include "picture.h"

#ifndef NULL
#define NULL ((void*)0)
#endif

typedef unsigned char BYTE;

static __inline__ BYTE y(BYTE r, BYTE g, BYTE b)
{
  /* (r * 0.29900000 + g * 0.58700000 + b * 0.11400000) */
  return (BYTE)(r * 299 + g * 587 + b * 114) / 1000;
}
static __inline__ BYTE u(int r2, int g2, int b2)
{
  /* (r2 * -0.16873590 + g2 * -0.33126410 + b2 * 0.50000000)/2 */
  return (BYTE)(((int)( (r2 * -1687 + g2 * -3313) / 10000 + (b2 >> 1)))	>> 1);
}
static __inline__ BYTE v(int r2, int g2, int b2)
{
  /* (r2 * 0.50000000 + g2 * -0.41868760 + b2 * -0.08131241)/2 */
  return (BYTE)((int)((r2 >> 1) - (g2 * 4187 + b2 * 813) / 10000 ) >> 1);
}

/*****f* soccer-pere/rgb2yuyv
 * SYNOPSIS
 *   int rgb2yuyv(Picture *yuyv_dest, Picture *rgb_src)
 * DESCRIPTION
 *   Convert a pix_rgb24 Picture to a pix_yuyv Picture.  Require the
 *   Picture pointers to point to initializied and allocated Picture
 *   structs with the same resolution.
 *
 *   Converting is done using the following formula:
 *
 *      y = r *  0.29900000 + g *  0.58700000 + b * 0.11400000
 *      u = r * -0.16873590 + g * -0.33126410 + b * 0.50000000
 *      v = r *  0.50000000 + g * -0.41868760 + b * -0.08131241
 *
 * RETURN VALUE
 *   0 on success and -1 on failure.
 *****/
int
rgb2yuyv(Picture *yuyv_dest, Picture *rgb_src)
{
  typedef struct _yuv422 { unsigned char y1,u,y2,v; } yuv422;
  typedef struct _rgb { unsigned char red,green,blue; } rgb;
  unsigned int i, elements;
  yuv422 *dest;
  rgb *src;

  if (NULL == rgb_src || NULL == yuyv_dest ||
      NULL == rgb_src->data || NULL == yuyv_dest->data ||
      pix_rgb24 != rgb_src->format || pix_yuyv != yuyv_dest->format)
    return -1;

  dest = (yuv422 *)yuyv_dest->data;
  src  = (rgb *)   rgb_src->data;
  elements = yuyv_dest->width * yuyv_dest->height / 2;

  for (i = 0; i < elements; i++)
    {
      BYTE r1,g1,b1,r2,g2,b2;
      BYTE rd,gd,bd;

      r1 = src[i*2].red;
      g1 = src[i*2].green;
      b1 = src[i*2].blue;

      r2 = src[i*2+1].red;
      g2 = src[i*2+1].green;
      b2 = src[i*2+1].blue;

      rd = r1 + r2;
      gd = g1 + g2;
      bd = b1 + b2;

      dest[i].y1 = y(r1, g1, b1);
      dest[i].y2 = y(r2, g2, b2);
      dest[i].u  = u(rd, gd, bd);
      dest[i].v  = v(rd, gd, bd);
    }
  return 0;
}
