/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-08-12
 *
 * RoboCup 2000 Eyebot soccer player control program.
 */

#ifndef _robotcontrol_hh
#define _robotcontrol_hh

#include "vec2d.hh"
#include "envstatus.hh"

class RobotControl
{
protected:
  EnvStatus *status;
  long lastdecision;
public:
  RobotControl(EnvStatus *_status)
    : status(_status),
      lastdecision(status->lastupdate) {}
  virtual bool decide(void);
  virtual void driveTo(const vec2d &pos, radians endheading);
};

#endif /* _robotcontrol_hh */
