/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-10
 *
 * Scrolldown menu for the Eyebot.
 */

#ifndef _scrollmenu_hh
#define _scrollmenu_hh

class scrollmenu
{
private:
  static const int lcdtextwidth = 16;
  static const int lcdtextheigth = 8;
 public:
  scrollmenu(void);
  ~scrollmenu();

  bool initialize(const char *_title = 0);

  typedef void (*entryProc)(scrollmenu *menu, void *data, int direction);

  void setTitle(const char *title);
  bool addEntry(const char *entry, entryProc proc, void *data);
  void removeEntryCall(entryProc proc, void *data);
  void removeEntry(const char *entry, void *data);

  bool changeMenuText(entryProc proc, void *data, const char *text);

  void show(void);
  void exec(void);
 private:
  char title[lcdtextwidth+1];
  typedef struct _menuEntry {
    char entry[lcdtextwidth];
    entryProc proc;
    void *data;

    unsigned int entrylen; /* Calculated */
    struct _menuEntry *up, *down;
  } menuEntry;
  enum { maxentries = 20 };
  menuEntry entries[maxentries];
  menuEntry *bottom;
  menuEntry *current;

  menuEntry *screentop;
  menuEntry *screenbottom;

  unsigned int menulines;

  void display(menuEntry *current);

  void setEntry(menuEntry *me, const char *entry);
  menuEntry *newEntry(const char *entry, entryProc proc, void *data,
		      menuEntry *up, menuEntry *down);
  void deleteEntry(menuEntry *);
};

#endif /* _scrollmenu_hh */
