/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-08-20
 */

#ifndef _segment_hh
#define _segment_hh

#include <math.h>

#include "angles.h"
#include "vec2d.hh"
#include "triangle2d.hh"

class segment2d {
public:
  vec2d start;
  vec2d end;
  int length;
  float heading;

  segment2d(void) : length(0), heading(0.0) {};

  segment2d(const vec2d &s, const vec2d &e)
  {
    vec2d diff = e - s;
    heading = diff.heading();
    length  = diff.length();

    if (fabs(heading) > M_PI_2)
      {
	start = e;
	end   = s;
	heading = rad2rad(heading + M_PI);
      }
    else
      {
	start = s;
	end   = e;
      }
  }

/****f* soccer-pere/segment2d::rotate
 * DESCRIPTION
 *   Rotate a line segment rad radians around origo.
 ****/
  segment2d rotate(const float rad) const
  {
    return segment2d(start.rotate(rad), end.rotate(rad));
  }

  bool intersects(const segment2d &s) const
  {
    return triangle2d::turn (start,
			     end, s.start) != triangle2d::turn (start,
								end, s.end) &&
           triangle2d::turn (s.start,
			     s.end, start) != triangle2d::turn (s.start,
								s.end, end);
  }
};

#endif /* _segment_hh */
