/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-14
 *
 * RoboCup 2000 Eyebot soccer player control program.
 */

#ifndef _soccer_hh
#define _soccer_hh

#include <camera.hh>
#include <parselanguage.h>

#include "driver.hh"
#include "picture.h"
#include "vec2d.hh"
#include "segment2d.hh"
#include "psdbeam.h"

extern int cmvision_test(Camera *framegrabber);
extern int audio_test(void);
extern int pan_pos_test(Camera *grabber, Driver *driver);
extern int findGlobalId(lang_channel ch, Driver *drive);
extern int play_ball(lang_channel channel, Camera *camera, Driver *driver);
extern void find_timediff_test(lang_channel ch);
extern void test_panning(void);

extern "C" int getPSDRange(DeviceSemantics psdsem, int *min, int *max);

extern bool selflocate(int timelimit, const segment2d map[], int mapcount,
		       psdbeam_t edges[], unsigned int edgecount,
		       const vec2d &curpos, radians curheading,
		       vec2d *translation, radians *rotation);

#endif
