/* ---------------------------------------------------------------------------
| Filename:     roottest.c
|
| Authors:      Clement Soh & Meng-How Yau
|
| Description:  Do some square root computations on the eyebot
| ------------------------------------------------------------------------- */

/* Include header file */
#include <stdio.h>
#include <math.h>

/* Prototype */
float sqroot(float number);

/* Method */
float sqroot(float number)
{
  float NewNumber, CurrentNumber, err;
  int i = 0;

  NewNumber = number/2.0;

  do
    {
      i++;
      CurrentNumber = NewNumber;
      NewNumber = (CurrentNumber + (number/CurrentNumber))/2.0;
#if 0
      err=number/(NewNumber*NewNumber);
#else
      err = (number - (NewNumber*NewNumber));
#endif
    } while ( abs(err) < 0.01);

  printf("Number of iteration is %i\n", i);
  return NewNumber;
}

#ifdef TEST
int
main()
{
  double error;
  float f;
  for (f = 1.0; f < 1000.0; f += 1.0)
    {
      float r1;
      float r2;
      printf("Calculating %f\n", f);
      r1 = sqroot(f);
      r2 = sqrt(f);
      error *= (r1/r2);
    }
  printf("Error: %f\n", error);
  return 0;
}
#endif
