/*
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-07-30
 *
 * Find time difference between me and the others in the radio network
 */

#include <eyebot.h>
#include <parselanguage.h>
#include <limits.h>
#include "debug.h"
#include "input.h"

int
sendPing(lang_channel ch, int now)
{
  int count = 0;
  RadioStatus curstatus;
  RADIOGetStatus(&curstatus);
  for (int i = 0; i < MAXEYE; i++)
    {
      if (curstatus.active[i] && i != OSMachineID())
	{
	  langEventPing event;
	  LCDPrintf("ping #%d\n", i);
	  event.timestamp = now;
	  event.type = langTypePing;
	  event.to = i;
	  lang_send(ch, (langEvent*)&event);
	  count++;
	}
    }
  lang_sendFlush(ch);
  return count;
}

struct timeinfo
{
  int count;
  int timediff[MAXEYE];
};

static int
lang_handler_cb(langEvent *event, void *ref)
{
  if (NULL == event || event->type != langTypePong)
    return -1;

  langEventPong *e = (langEventPong *)event;
  int now = OSGetCount();

  struct timeinfo *info = (struct timeinfo *)ref;
  if (info->timediff[e->from] != INT_MAX)
    mydebug("Dup from %d\n", e->from);
  else
    {
      info->count--;
      info->timediff[e->from] = e->timestamp - (now + e->time)/2;
      mydebug("G: %d %d %d", now, e->time, e->timestamp);
    }
  return 0;
}

void
find_timediff_test(lang_channel ch)
{
  struct timeinfo info;
  long start = OSGetCount();
  LCDClear();
  LCDPrintf("Find timediff\n");

  for (int i = 0; i<MAXEYE; i++)
    {
      info.timediff[i] = INT_MAX;
    }
  info.count = sendPing(ch, start);

  LCDPrintf("ping %d\n", info.count);

  /* Wait 10 seconds for replies */
  while (info.count && start + 1000 > OSGetCount())
    {
      if (lang_messageWaiting(ch))
	lang_receive(ch, lang_handler_cb, &info);
    }

  for (int i = 0; i<MAXEYE; i++)
    {
      if (INT_MAX != info.timediff[i])
	LCDPrintf("D: %d = %d\n", i, info.timediff[i]);
    }
  LCDPrintf("Press any key");
  inputWait(ANYKEY);
}
