/****c* soccer-pere/vec2d
 * DESCRIPTION
 *   2D integer triangle class.  Based on example classes by Carlos
 *   Moreno.
 * AUTHOR
 *   Petter Reinholdtsen <pere@td.org.uit.no>, 2000-08-21
 ****/

#ifndef _triangle2d_hh
#define _triangle2d_hh

#include <math.h>

class triangle2d
{
public:
  enum {
    right_turn = -1,
    collinear = 0,
    left_turn = 1
  };

  triangle2d(const vec2d &p1 = vec2d(0,0),
	     const vec2d &p2 = vec2d(0,0),
	     const vec2d &p3 = vec2d(0,0))
    : v1(p1), v2(p2), v3(p3) {};

  int signed_area(void) const
  {
    return (v1.x * (v2.y - v3.y) +
	    v2.x * (v3.y - v1.y) +
	    v3.x * (v1.y - v2.y));
  };

  int area (void) const
  {
    return abs (signed_area());
  }


  int orientation (void) const
  {
    int s_a = signed_area();

    return s_a > 0 ? left_turn : (s_a < 0 ? right_turn : collinear);
  }

  static int turn (const vec2d & p1, const vec2d & p2, const vec2d & p3)
  {
    return triangle2d(p1,p2,p3).orientation();
  }

  bool contains (const vec2d &p) const
  {
    return turn (v1,v2,p) == turn (v2,v3,p) &&
           turn (v2,v3,p) == turn (v3,v1,p);
  }

private:
  vec2d v1, v2, v3;
};

#endif /* _triangle2d_hh */
