/*
 * C API to interface with CMVision image capture class.
 */

#ifndef __C_CAPTURE_H
#define __C_CAPTURE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "picture.h"

typedef void *capref;

capref Camera_newCamera(unsigned int nwidth, unsigned int nheight,
                        pixel_format nfmt);        /* factory */
void Camera_delete(capref ref); /* destructor */
int Camera_initialize(capref ref, unsigned int nwidth, unsigned int nheight,
                       pixel_format nfmt, char *device);
int Camera_init(capref ref, unsigned int nwidth, unsigned int nheight);
int Camera_setup(capref ref);
void Camera_close(capref ref);
Picture *Camera_capture(capref ref);
Picture *Camera_get(capref ref);
long Camera_getTimestamp(capref ref);
long Camera_getTime(capref ref);
double Camera_getFramerate(capref ref);
int Camera_framerateOn(capref ref, int state);
int Camera_getFileDescriptor(capref ref);

#ifdef __cplusplus
}
#endif

#endif
