#include <stdlib.h>

#include <eyebot.h>
#include "camera.hh"

int
main()
{
  int count = 0;

  LCDPrintf("CamTest\n");

  Camera *grabber = Camera::newCamera(imagecolumns, imagerows, pix_rgb24);
  if (NULL == grabber)
    {
      LCDPrintf("Caminit fail\n");
      return -1;
    }
  else
    {
      LCDPrintf("Caminit ok\n");
      OSSleep(50);
    }

  grabber->framerateOn(true);

  LCDClear();
  LCDSetString(0, 10, "Cam-");
  LCDSetString(1, 10, "test");
  LCDSetString(3, 10, "FPS:");
  LCDSetString(5, 10, "Count:");
  LCDMenu(" ", " ", " ", "END");
  while (KEY4 != KEYRead())
    {
      Picture *frame = grabber->capture();
      if (NULL == frame)
	LCDPrintf("capture() #%d failed", count);
      LCDPutColorGraphic((colimage*)frame->data);
      LCDSetPrintf(4,10, "%5.2f", grabber->getFramerate());
      LCDSetPrintf(6,10, "%05d", count++);
    }
  grabber->close();

  /* Workaround for linker bug */
  free(malloc(1));

  return 0;
}
