#ifndef _dummy_capture_h
#define _dummy_capture_h

#include "camera.hh"

#ifdef HAVE_DUMMYCAMERA

class DummyCamera : public Camera {
 public:
  DummyCamera() : dummyfd(-1), index(0), count(0), pictures(0) {}
  bool initialize(unsigned int nwidth = 0, unsigned int nheight = 0,
		  pixel_format nfmt = pix_unknown,
		  char *device = 0);
  void close(void);
  Picture *capture(void);

  int getFileDescriptor(void) { return dummyfd; };
 protected:
  long getTime(void);
 private:
  int dummyfd;

  // index of next image to display
  int index;

  // Number of frames in camera sequence
  int count;

  // storage for fake camera frames
  Picture *pictures;

  int loadImage(const char *fname, Picture * img);
  void swapRgbToBgr(Picture *img);
};

#endif /* HAVE_DUMMYCAMERA */

#endif // Camera_h
