/* -*- C++ -*-
 *
 * Author: Petter Reinholdtsen <pere@td.org.uit.no>
 * Date:   2000-05-10
 *
 * Eyebot camera frame capture class.
 */

#ifndef _eyebotcamera_h
#define _eyebotcamera_h

#include "camera.hh"

#ifdef HAVE_EYEBOT

class EyebotCamera : public Camera
{
  int starttime; /* Used to turn off autobrightness after 20 seconds */
 public:
  EyebotCamera() : Camera() {}
  ~EyebotCamera() { close(); }
  bool initialize(unsigned int nwidth, unsigned int nheight,
		  pixel_format nfmt = pix_rgb24, char *device = 0);
  void close(void);
  Picture *capture();
  long getTime(void);
};

#endif /* HAVE_EYEBOT */

#endif /* _eyebotcamera_h */
