/*
 * Make sure all parts of the program work on the same image format.
 */

#ifndef _picture_h
#define _picture_h

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  pix_unknown = 0,

  pix_bitmap,/* 1 bit per pixel, order 76543210 | 76543210 | ... */

  pix_grey4, /* 4 lowest bit in 8 bit byte */
  pix_grey,  /* 8 bit luminosity */

  pix_index, /* 8 bit indexed colors.  Use obdata to store the color table */

  pix_rggb,  /* 32 bit Eyecam native format */

  pix_rgb24, /* RGB 24 bit (8:8:8) */
  pix_rgb32, /* RGB 32 bit (8:8:8:8) Last byte is not used */
  pix_bgr24, /* BGR 24 bit (8:8:8) */
  pix_bgr32, /* BGR 32 bit (8:8:8:8) Last byte is not used */

  pix_hsv32, /* HSV 32 bit (8:8:8:8) LAst byte is not used */

  /* XXX These must be verified and consistently defined against V4L, V4L2 */
  pix_yuyv,  /* YUV 16 bit (4:2:2 packed) */
  pix_yuv12, /* YUV 12 bit (4:2:0 planar) */
  pix_yuv9   /* YUV  9 bit (4:1:0 planar) */
} pixel_format;

typedef int picture_coord;

typedef struct {
    picture_coord width, height; /* size of image */
    int xoffset;                /* number of pixels offset in X direction */
    pixel_format format;        /* XYBitmap, XYPixmap, ZPixmap */
    unsigned int datasize;      /* Size of the mem block pointed to by data */
    unsigned char *data;        /* pointer to image data */
    int bytes_per_line;         /* accelarator to next line */
    int bytes_per_pixel;        /* bytes per pixel */
    int obformat;               /* format of the obdata */
    void *obdata;               /* hook for the object routines to hang on */
    int flags;                  /* PIC_READONLY */
} Picture;

#ifdef __cplusplus
}
#endif

#endif /* _picture_h */
