#ifndef __v4l2_camera_h
#define __v4l2_camera_h

#include "camera.hh"

#ifdef HAVE_V4L2

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include <linux/fs.h>
#include <linux/kernel.h>
#include <linux/videodev2.h>

#define DEFAULT_VIDEO_DEVICE  "/dev/video"
#define VIDEO_STANDARD        "PAL"
#define DEFAULT_IMAGE_WIDTH   160
#define DEFAULT_IMAGE_HEIGHT  120
#define STREAMBUFS            4

class V4L2Camera : public Camera {
public:
  V4L2Camera() { vid_fd = -1; }
  ~V4L2Camera() { close(); }
  bool initialize(unsigned int nwidth = DEFAULT_IMAGE_WIDTH,
		  unsigned int nheight = DEFAULT_IMAGE_HEIGHT,
		  pixel_format nfmt = pix_bgr24,
		  char *device = DEFAULT_VIDEO_DEVICE);
  void close(void);
  Picture *capture(void);
  int getFileDescriptor(void) { return vid_fd; };
protected:
  long getTime(void);
private:
  struct {
    v4l2_buffer vidbuf;
    char *data;
  } vimage[STREAMBUFS];      // buffers for images
  int vid_fd;                    // video device
  struct v4l2_format fmt;        // video format request
  int map_to_v4l2_format(pixel_format format);
};

#endif /* HAVE_V4L2 */

#endif /* __v4l2_camera_h */
