#ifndef _parselanguage_h
#define _parselanguage_h

#ifdef  __cplusplus
extern "C" {
#endif

#include "language.h"

typedef int lang_channel;

/* Prepare and clean up */
lang_channel lang_init(void);
int lang_release(lang_channel);

/* Tell the others something */
int lang_send(lang_channel ch, langEvent *event);

/* If buffering, send the packet off now */
int lang_sendFlush(lang_channel ch);

int lang_messageWaiting(lang_channel ch);

/* This reads radio messages and passes them over to handler */
typedef int (*lang_handler_t)(langEvent *event, void *ref);
int lang_receive(lang_channel ch, lang_handler_t handler, void *ref);

/* translates byte codes to english test */
const char *lang_transName(unsigned char code);
const char *lang_transType(unsigned char code);
const char *lang_transCmd(unsigned char code);
const char *lang_transPri(unsigned char code);

#ifdef  __cplusplus
}
#endif

/* Make up a good name for this...
 * Suggestions: units_per_circle, angle_per_circle, circle, ...
 */

#define LANG_ANGLE_RES (1024)

#include <math.h>

/****f* language/lang_deg2angle
 * SYNOPSIS
 *   int lang_deg2angle(double deg);
 * DESCRIPTION
 *   Convert degrees (360 circle) to language specific angle unit(radians
 *   times 1024).
 * RESULT
 *   angle
 * SEE ALSO
 *   lang_rad2angle()
 *****/
extern __inline__ short int
lang_deg2angle(double deg)
{
  return (short int)(deg*1024.0*M_PI/180.0);
}

/****f* language/lang_angle2deg
 * SYNOPSIS
 *   int lang_angle2deg(double deg);
 * DESCRIPTION
 *   Convert language specific angle unit(radians times 1024) to
 *   degrees (360 circle).
 * RESULT
 *   degrees
 * SEE ALSO
 *   lang_deg2angle()
 *****/
extern __inline__ double
lang_angle2deg(short int angle)
{
  return (angle*180/(1024.0*M_PI));
}

/****f* language/lang_rad2angle
 * SYNOPSIS
 *   int lang_rad2angle(double radians)
 * DESCRIPTION
 *   Convert radians (2 times PI circle) to language specific angle
 *   unit (radians times 1024).
 * RESULT
 *   angle
 * SEE ALSO
 *   lang_deg2angle(), lang_angle2rad()
 *****/
extern __inline__ short int
lang_rad2angle(double rad)
{
  return (short int)(rad * 1024.0);
}

/****f* language/lang_angle2rad
 * SYNOPSIS
 *   double lang_angle2rad(short int angle)
 * DESCRIPTION
 *   Convert language specific angle unit (radians times 1024) to
 *   radians (2 times PI circle).
 * RESULT
 *   radians
 * SEE ALSO
 *   lang_rad2angle()
 *****/
extern __inline__ double
lang_angle2rad(short int angle)
{
  return angle / 1024.0;
}

#endif /* _parselanguage_h */
