#include "picture.h"
#include "picproc.h"

/****f* libpicproc/picproc_bitmap_drawPixel
 * SYNOPSIS
 *   #include "picproc.h"
 *   int picproc_bitmap_drawPixel(Picture *img,
 *                                picture_coord column, picture_coord row,
 *                                int value);
 * DESCRIPTION
 *   Set the pixel at (column,row) to the given value.  Only works on
 *   pix_bitmap pictures.
 * RETURN VALUE
 *   0 on success, -1 if the parameters are inconsistent.
 ****/
int
picproc_bitmap_drawPixel(Picture *img, picture_coord column, picture_coord row,
                         int value)
{
  int dataindex;

  if (0 == img || img->format != pix_bitmap ||
      0 > column || column >= img->width ||
      0 > row || row >= img->height)
    return -1;

  dataindex = row* (img->width) / 8 + column/8;
  if (value)
    img->data[dataindex] |= 1 << (7 - column % 8);
  else
    img->data[dataindex] &= ~(1 << (7 - column % 8));
  return 0;
}

/****f* libpicproc/picproc_bitmap_getPixel
 * SYNOPSIS
 *   #include "picproc.h"
 *   int picproc_bitmap_getPixel(Picture *pic,
 *                               picture_coord column, picture_coord row);
 * DESCRIPTION
 *   Get the pixel value at (column,row).  Only works on pix_bitmap
 *   pictures.
 * RETURN VALUE
 *   0 or 1 on success, -1 if the parameters are inconsistent.
 ****/
int
picproc_bitmap_getPixel(Picture *pic, picture_coord column, picture_coord row)
{
  int dataindex;

  if (0 == pic || pic->format != pix_bitmap ||
      column >= pic->width || row >= pic->height)
    return -1;

  dataindex = row* (pic->width) / 8 + column/8;
  return pic->data[dataindex] & (1 << (7 - column % 8)) ? 1 : 0;
}
