#include "picture.h"
#include "picproc.h"

#include <stdio.h>
#include <unistd.h>
#include <math.h>

int
main()
{
  Picture *pic;
  int white = 0x00ffffff;
  int radius = 25;
  FILE *fp;
  pic = picture_new(320, 320, pix_rgb24);

  picproc_drawLine(pic, 0, 0, pic->width-1, pic->height-1, white);
  picproc_drawBox(pic, 0, 0, pic->width-1, pic->height-1, white);

  picproc_drawCircle(pic, pic->width/2, pic->height/4, radius, white);
  picproc_drawArrow(pic, pic->width/2, pic->height/4, radius-3, 10,
                    0, white);

  picproc_drawCircle(pic, pic->width/4, pic->height/2, radius, white);
  picproc_drawArrow(pic, pic->width/4, pic->height/2, radius-3, 10,
                    M_PI_2, white);

  picproc_drawCircle(pic, pic->width/2, pic->height/2, radius, white);
  picproc_drawArrow(pic, pic->width/2, pic->height/2, radius-3, 10,
                    M_PI_4, white);

  picproc_drawCircle(pic, 3*pic->width/4, pic->height/2, radius, white);
  picproc_drawArrow(pic, 3*pic->width/4, pic->height/2, radius-3, 10,
                    -M_PI_2, white);

  picproc_drawCircle(pic, pic->width/2, 3*pic->height/4, radius, white);
  picproc_drawArrow(pic, pic->width/2, 3*pic->height/4, radius-3, 10,
                    M_PI, white);

  fp = fopen("demo.ppm", "w");
  picproc_pnmEncode(pic, write, fileno(fp));
  fclose(fp);

  picture_delete(pic);
  pic = NULL;
  return 0;
}
