#ifndef _picproc_h
#define _picproc_h

#ifdef __cplusplus
extern "C" {
#endif

#include "picture.h"

  /* common.c */
  void picture_init(Picture *pic, picture_coord width, picture_coord height,
                    pixel_format format, int bytes_per_pixel,
                    unsigned char *data, unsigned int datasize);
  void picture_clear(Picture *img);
  Picture *picture_new(picture_coord width, picture_coord height,
                       pixel_format format);
  int picture_delete(Picture *pic);

  int picproc_drawPixel(Picture *img, picture_coord column, picture_coord row,
                        int colour);
  int picproc_drawCircle(Picture *img, picture_coord column, picture_coord row,
                         int radius, int colour);
  int picproc_drawLine(Picture *pic, picture_coord column1, picture_coord row1,
                       picture_coord column2, picture_coord row2, int color);
  int picproc_drawBox(Picture *pic, picture_coord column1, picture_coord row1,
                      picture_coord column2, picture_coord row2, int color);
  int picproc_drawArea(Picture *pic, picture_coord column1, picture_coord row1,
                       picture_coord column2, picture_coord row2, int color);
  int picproc_drawArrow(Picture *pic, picture_coord column, picture_coord row,
                        int radius, int base, double angle, int color);

  typedef long (*picproc_writer)(int ref, const void *buf, long count);
  int picproc_pnmEncode(Picture *pic, picproc_writer writer, int ref);


  /* bitmap.c */
  int picproc_bitmap_drawPixel(Picture *img, picture_coord column,
                               picture_coord row, int value);
  int picproc_bitmap_getPixel(Picture *pic, picture_coord column,
                              picture_coord row);

  /* rgb24.c */
  int picproc_rgb24_drawPixel(Picture *img, picture_coord column,
                              picture_coord row, int colour);

#ifdef __cplusplus
}
#endif

#endif /* _picproc_h */
