#include "picture.h"
#include "picproc.h"

/****f* libpicproc/picproc_rgb24_drawPixel
 * SYNOPSIS
 *   #include "picproc.h"
 *   int picproc_rgb24_drawPixel(Picture *img, picture_coord column,
 *                               picture_coord row, int value);
 * DESCRIPTION
 *   Set the pixel at (column,row) to the given value.  Only works on
 *   pix_rgb24 pictures.  The 32 bits in color is read as red 16-24,
 *   green 8-15 and blue 0-7.
 * RETURN VALUE
 *   0 on success, -1 if the parameters are inconsistent.
 ****/
int
picproc_rgb24_drawPixel(Picture *img, picture_coord column, picture_coord row,
                        int color)
{
  int dataindex;
  unsigned char *data;
  if (0 == img ||
      0 > column || column >= img->width ||
      0 > row || row >= img->height)
    return -1;

  dataindex = row*img->bytes_per_line + column * img->bytes_per_pixel;
  data = img->data;
  switch (img->format)
    {
    case pix_rgb24:
    case pix_rgb32:
      data[dataindex+0] = (color >> 16) & 0xFF; /* red   */
      data[dataindex+1] = (color >>  8) & 0xFF; /* green */
      data[dataindex+2] = (color >>  0) & 0xFF; /* blue  */
      break;
    case pix_bgr24:
    case pix_bgr32:
      data[dataindex+2] = (color >> 16) & 0xFF; /* red   */
      data[dataindex+1] = (color >>  8) & 0xFF; /* green */
      data[dataindex+0] = (color >>  0) & 0xFF; /* blue  */
      break;
    default:
      return -1;
      break;
    }

  return 0;
}
