/***********************************************************************************************************/
/* "Loadable" Constants for the vision library                                                             */
/***********************************************************************************************************/

            /* Running on simulator or on EyeBot */
#define VIS_SIM 0 /* Using simulator or not */

            /* Using Malloc() or not */
/*#define USE_MALLOC 1*/

            /* B&W image display parameters */
#define VIS_BWIMAGEROWS    64
#define VIS_BWIMAGECOLUMNS 128

            /* Denoising depth, fast algorithm, processing step */
#define VIS_DEPTH 1 /* denoise one dot around */
#define VIS_FAST  0 /* use fast algorithm, only for depth=1 */
#define VIS_STEP  1 /* process every dots or two dots only */
/* loop in internal structure is VIS_STEP-1, i.e. the binary shift */

           /* Color class "step" parameters */
#define VIS_VALID_BITS 5                     /* number of valid bits 1..8 */
#define VIS_VALUES     (1 << VIS_VALID_BITS) /* values for n valid bits */
#define VIS_SHIFT_BITS (8 - VIS_VALID_BITS)  /* bits to shift to get n valid bits */
#define VIS_COEF       (1 << VIS_SHIFT_BITS) /* coef used to shift */

           /* Robot, ball and field caracteristics in mm, radians and pixels */
static const int   VIS_CAM_RLEVEL[2][5]={{39, 36, -1, -1, 37}, {-1, -1, -1, -1, -1}};
static const int   VIS_CAM_GLEVEL[2][5]={{36, 39, -1, -1, 38}, {-1, -1, -1, -1, -1}};
static const int   VIS_CAM_BLEVEL[2][5]={{34, 32, -1, -1, 27}, {-1, -1, -1, -1, -1}};
static const int   VIS_CAM_HEIGHT[2][5]={{-1, 65, -1, -1, -1}, {-1, -1, -1, -1, -1}};
static const int   VIS_CAM_LENGHT[2][5]={{-1, -5, -1, -1, -1}, {-1, -1, -1, -1, -1}};
static const int   VIS_CAM_ALPHA[2][5]={{-1, 136, -1, -1, 136}, {-1, -1, -1, -1, -1}};
static const float VIS_CAM_BETA[2][5]={{-1, -0.0279, -1, -1, -0.1484}, {-1, -1, -1, -1, -1}};
static const float VIS_CAM_ANGLE[2][5]={{0.85, 0.85, 0.85, 0.85, 0.85}, {0.85, 0.85, 0.85, 0.85, 0.85}};

           /* Upper limit of the goal */
static const int VIS_GOAL_UP[2][5]={{0, 28, 0, 0, 0}, {0, 0, 0, 0, 0}};

           /* Soccer field informations */
#define VIS_BALL_RADIUS 21   /* Ball radius in mm */
#define VIS_GOAL        500  /* Goal width in mm */
#define VIS_CAL_DIST    1500 /* Distance between robot and goal at calibration */
