/** @name user.c 

    This file contains function definitions for the serial communications protocol.

    @author Daniel Storey, UWA, 1998
    @version 1.0   */

/*@{*/

/*************************
 * user.c
 * Top level functions for transceiver application */
void LOWRECEIVE();
void LOWSEND();
int RadioInit(char number);
int RadioTx(char id, char *message, int length);
int RadioRx(char *message);
int RadioRxB(char *message);
void RadioCheck();
void BufferCheck();
void RadioRelease();

/*************************
 * top-level.c
 * Functions relating to string input and output
 * from the communications system code */

Channel initiate_serial_communications(char* my_address, char* next_address, char* broadcast_address, int baudrate, bool wireless, bool master);
void force_send(Channel *channel);
int comms_send(const char* array, char* address, int length, Channel *channel);
int comms_receive(char *array, char *address, Channel *channel);
int receive_queue(Channel *channel);
char* comms_error(char* string, Channel *channel);
int error_queue(Channel *channel);
char map_char(char character);
char unmap_char(char character);
void convert_to_comms_string(char* string, const char* array, int length);
void decipher_comms_string(char* array, const char* string);

/*************************
 * low-level.c
 * Functions pertaining to the lowest level of the communications system */ 

bool can_send(Channel *channel);
void low_send(Channel *channel);
void send_packet(Packet packet, bool special, Channel *channel);   
bool packet_owner(char* string, Channel *channel);
bool check_crc(Packet *packet);
bool enough_string_left(char* string);
bool end_packet_correct(char* string);
int total_packet_length(char* pack_len);
void extract_packet(char* string, Channel *channel);
int low_receive(Channel *channel);

/*************************
 * list.c
 * Implement a linked list for packet storage */

void initialise_queue(Queue *q);
void increment_packet_in_queue(Queue *q, int item_number);
bool match_and_remove(Queue *q, char packet_number);
void remove_from_queue(Queue *q, int item_number);
Packet get_from_queue(Queue *q, int item_number);
int enqueue(Queue *q, Packet p);
Packet dequeue(Queue *q);
int queue_length(Queue *q);
bool empty(Queue *q);
void initialise_special_queue(Special_Queue *q);
int special_enqueue(Special_Queue *q, Packet p);
Packet special_dequeue(Special_Queue *q);
int special_queue_length(Special_Queue *q);
int string_queue_length(String_Queue *q);
int string_dequeue(String_Queue *q, char *string, char* address);
int string_enqueue(String_Queue *q, char* string, char *address);
void initialise_string_queue(String_Queue *q);
void initialise_recframe_queue(RecFrame_Queue *q);
int recframe_dequeue(RecFrame_Queue *q);
int recframe_enqueue(RecFrame_Queue *q, char* number, char* address);
void recframe_increment_age(RecFrame_Queue *q);
bool recframe_match(RecFrame_Queue *q, char* number, char* address);
int recframe_queue_length(RecFrame_Queue *q);

/*************************
 * packetise.c
 * Functions related to creating packets of data */

void int_2_packet_length(char a[3], int len);
int packet_length_2_int(char a[3]);
bool is_special_packet(char type[3]);
int special_packet_length(char type[3]);
int packet_length(char type[3]);
Packet generate_packet(Packet packet, const char* address, const char* type, const char* data, Channel *channel);
void write_preamble(Channel *channel);
Packet receive_packet(Packet packet, const char* string);
Packet generate_packet_ok(const Packet packet, Channel *channel);
Packet generate_token_packet(Channel *channel);
char increment_packet_number(Channel *channel);
void decrement_packet_number(Channel *channel);

/*************************
 * crc.c
 * Funtions related to obtaining a crc value for a given string */

unsigned long crc32(const unsigned char *s, unsigned int len);
char *ltostr(long num, char* string);
void crc(char* result, const char* data);

/*************************
 * string.c
 * safe string functions */

int string_length(char* string);
char* string_concatenate(char* destination, char* source);
char* string_copy(char* destination, char* source);

/*************************
 * eye-serial.c
 * implement reading and writing from the PC serial port */

void initalise_serial_port(Channel channel);
int send_string(char *str, int length, Channel *channel);
int read_until_packet_end(Channel *channel);
void tx_send(void);
void tx_receive(void);
void send_check_str(char* str, int length);

/*************************
 * buffer.c
 * implement an additional buffer for the serial port */

int OSRecvBuff(char* character);
int OSCheckInBuff();
void OSFlushInBuff();
int OSSendBuff(char* character);
int OSCheckInBuff();
void OSFlushInBuff();

void read_serial_data(int serial_port);
void write_serial_data(int serial_port);



/*************************
 * control.s
 * Set the transceiver to send of receive mode */

/* WL_SEND(); */
/* WL_RECV(); */ 
/* WL_CD(); */




