#include "serial_communications.h"

/** @name string.c 

    This file contains functions to handle strings.  They are more robust than the standard functions in string.h.

    @author Daniel Storey, UWA, 1998
    @version 1.0   */

/*@{*/

/*************************************************************************/
/** Find the length of a string.
    If a string pointer is NULL, return 0. Otherwise return the length of the string.

    @param string string, the string for which the length is to be measured.
    @return int, the length of a string. */
/*************************************************************************/
int string_length(char* string)
{
  int i = 0;
  
  if(string==NULL)
    return 0;
  while(string[i]!='\0')
    i++;
  return i;
}

/*************************************************************************/
/** Concatenate two strings.
    Check the length of both strings is greater than 0. Concatenate them. Ensure the '\0' marker is placed at the end of the destination string.

    @param destination string, the destination string for the concatenation.
    @param source string, the source string for the concatenation.
    @return char*, a poiner to the start of the destination string. */
/*************************************************************************/
char* string_concatenate(char* destination, char* source)
{
  int d_length, s_length, i;

  d_length = string_length(destination);
  s_length = string_length(source);

  for(i=0; i<s_length; i++) {
    destination[i+d_length] = source[i];
  }
  destination[d_length + s_length] = '\0';
  
  return destination;
}

/*************************************************************************/
/** Copy the source string to the destination string.
    Check the length of the source string, then copy it to the destination.

    @param destination string, the destination string.
    @param source string, the source string.
    @return char*, a poiner to the start of the destination string. */
/*************************************************************************/
char* string_copy(char* destination, char* source)
{
  int length, i;

  length = string_length(source);
  
  for(i=0; i<length; i++) {
    destination[i] = source[i];
  }
  destination[length] = '\0';
  
  return &destination[0];
}
