#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "librobi/librobi.h"
#include "librobi/protos.h"
#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "kern.h"
#include "rs232.h"

void send(void);

int serial = 100;

main()
{
  char c;
  int key, i = 0;
  int status;

  printf("Serial port 1 or 3.\n");
  LCDMenu("1","3","","");
  key = KEYGet();
  LCDMenu(" "," "," "," ");

  if(key==KEY1) serial = SERIAL1;
  if(key==KEY2) serial = SERIAL3;
    
  

    
  LCDMenu("Rec","Send","","");
  key = KEYGet();
  
  if(key==KEY1) {
    LCDMenu(" "," "," "," ");
    if(OSInitRS232(SER9600, NONE, serial)!=0)
      printf("Startup Error: %d\n", OSInitRS232(SER9600, NONE, serial));
    WL_RECV();
    OSWait(2);
    printf("Rec:\n");
    while(1) {
      /*while(c!='!')
	OSRecvRS232(&c, serial);
	putchar(c);
	printf("#%d chars to go\n", OSCheckInRS232(serial));
	while(c!='#') {
	OSRecvRS232(&c, serial);
	putchar(c);
	}
	printf("\n");*/
      printf("Receive?");
      LCDMenu("Yes","Yes","Yes","No");
      key = KEYGet();
      if(key==KEY4)
	break;
      printf("%d in FIFO\n", OSCheckInRS232(serial));
      status = OSRecvRS232(&c, serial);
      if(status!=0) {
	if(status==1) {
	  printf("Error: Timeout\n");
	}
	else if(status==2) {
	  printf("Error: Receive Status\n");
	}
	else if(status==10) {
	  printf("Er:Bad Int\n");
	}
	else printf("Unknown Error\n");
      }
      putchar(c);
      printf("\n");
    }
  }
  
  if(key==KEY2) {
    LCDMenu(" "," "," "," ");

    WL_RECV();
    if(OSInitRS232(SER9600, NONE, serial)!=0)
      printf("Startup Error: %d\n", OSInitRS232(SER9600, NONE, serial));
    printf("Send Std:\n");
    printf("Initialised\n");
    while(1) {
      LCDClear();
      printf("Send?\n");
      LCDMenu("Yes","Yes","Yes","No");
      key = KEYGet();
      if(key==KEY4)
	break;
      WL_SEND();
      OSWait(2);
      send();
      while(OSCheckOutRS232(serial)!=0);
      WL_RECV();
      OSWait(2);
    }
  }
}

 


void send(void) {
  int i;
  char a, b;
   char str[] = "This is a string of data transmitted just for you!";

  a = (unsigned char) 0x55;
  b = (unsigned char) 0xff;

  printf("*Send*\n");
    
  /* preamble */
  for (i=0; i<95; i++) {
    OSSendRS232(&a, serial);
   }
  /* lock UART */
  for (i=0; i<5; i++) {
    OSSendRS232(&b, serial);
  }
  /* send data */
  for(i=0; i<40; i++) {
    OSSendRS232(&str[i], serial);
  }
  for(i=0; i<40; i++) {
    OSSendRS232(&str[i], serial);
  }
  
  printf("sent**\n");
  
}  
/*

  rm temp.o -f
  gcc68o temp.c
  gld68o temp.o control.o
  dl temp.hex

*/






